//
//  NSObject+MCAdditions.h
//  MCFoundation
//
//  Created by Alykhan Jetha on Thu Jun 12 2003.
//  Copyright (c) 2003 __MyCompanyName__. All rights reserved.
//

#import <Foundation/NSObject.h>

#import "MCFoundationDefines.h"

@class NSBundle;

@interface NSObject (MCAdditions) 

+ (NSBundle *)bundle;
- (NSBundle *)bundle;


	/*!
				Calls NSBundle's localizedStringForKey:value:table:
	 on the bundle of this instance's class. If that calls returns nothing, then the passed in string is returned. This method expects that the localized values will in a file called 'Localizable.strings'.
	 
	 This method is safe to use even if you don't have that file setup.
	 
	 */
+ (NSString *)localizeString:(NSString *)str;
- (NSString *)localizeString:(NSString *)str;
// Same as above, except you can specify the file to use (table, no suffix)
+ (NSString *)localizeString:(NSString *)str table:(NSString*)table;

/*!
 @method     localizeString: table: startWithBundle:
 @abstract   Attempts to localize the string by checking the bundle and the main bundle.
 @discussion Given a table, it checks that table in the class's bundle, then the Nibs table in that same bundle. If that fails, it tries with the mainBundle. If nil is passed for Table, the Localizable is used.
 */
+ (NSString *)localizeString:(NSString *)str table:(NSString*)aTable startWithBundle:(NSBundle *)aBundle;

- (NSString *)localizeString:(NSString *)str table:(NSString*)table;

- (NSString *)localizeString:(NSString *)str table:(NSString *)table fromBundle:(NSBundle *)bundle;
- (NSString *)localizeString:(NSString *)str fromBundle:(NSBundle *)bundle;

//- (void)logAddress;

- (NSComparisonResult)caseInsensitiveCompareIfAvailable:(id)anObj;


// uses NSKeyedArchiver and unarchiver to make an autoreleased copy
- (id)duplicate;

//- (id)stringsForKeypathByFlatteningArrays:(NSString *)keypath;

- (NSArray *)arrayWithObjectsFromArrayKeyPaths:(NSArray *)arrayKeypaths;


- (id)performSelector: (SEL)aSelector withObjects: (id)obj, ...;

#pragma mark Exporting
+ (NSString*)tabDelimitedRepresentationOfObject:(id)exportObj usingFieldDicts:(NSArray*)fieldDicts;
+ (BOOL)createTabDelimitedFileWithFilename:(NSString*)aFilename
							   fromObjects:(NSArray*)objs
					 withExportFieldsDicts:(NSArray*)fieldDicts;
+ (BOOL)createTabDelimitedFileWithFilename:(NSString*)aFilename
							   fromObjects:(NSArray*)objs
					 withExportFieldsDicts:(NSArray*)fieldDicts
								  encoding:(NSStringEncoding)encoding
							lineEndingType:(MCLineEndingType)lineEndingType;

+ (NSString *)commaDelimitedRepresentationOfObject:(id)exportObj usingFieldDicts:(NSArray *)fieldDicts;
+ (BOOL)createCommaDelimitedFileWithFilename:(NSString *)aFilename
								 fromObjects:(NSArray *)objs
					   withExportFieldsDicts:(NSArray *)fieldDicts
									encoding:(NSStringEncoding)encoding
							  lineEndingType:(MCLineEndingType)lineEndingType;

- (NSArray*)contributeExportFields;
- (NSArray*)expandKeysInExportFields:(NSArray*)fieldDicts;

- (NSString*)tabDelimitedRepresentation:(NSArray*)fieldDicts;
- (NSString *)commaDelimitedRepresentation:(NSArray *)fieldDicts;

- (NSString *)terseDescription;
- (NSString *)briefDescription;
- (NSString *)longDescription;

#pragma mark OS Version utilities

+(BOOL)OSVersionMatchesMajorVersion:(NSUInteger)majorTest minorVersion:(NSUInteger)minorTest revisionVersion:(NSUInteger)revisionTest;
+ (BOOL)isRunningOnLeopardOrLater;
+ (BOOL)isRunningOnSnowLeopardOrLater;
+ (BOOL)isRunningOnLionOrLater;
+ (BOOL)isRunningOnHighSierraOrLater;

+ (NSString *)currentOSVersionString;
+ (NSString *)currentHardwareSystemName;

@end
